

function display_menu(key_hold) {
	var picno = $MENU_PICNO;
	
	format_menu_picture_list();
	format_button_picture_list();
	format_picture_text();
	erase_menu_picture();
	
	$cursor_x_max = 1;
	$cursor_y_max = 1;
	$max_menu_page = 0;
	
	//メニューシーンごとの設定
	switch ($menu_scene) {
		case 'test':
			$cursor_x_max = 1;
			$cursor_y_max = 2;
			break;
		case 'title':
			$cursor_x_max = 1;
			$cursor_y_max = 2;
			break;
		case 'mainmenu':
			$cursor_x_max = 1;
			$cursor_y_max = 4;
			break;
		case 'save':
			$cursor_x_max = 1;
			$cursor_y_max = 4;
			break;
		case 'load':
			$cursor_x_max = 1;
			$cursor_y_max = 4;
			break;
		case 'titleback':
			$cursor_x_max = 1;
			$cursor_y_max = 2;
			break;
		case 'interlude':
			$cursor_x_max = 1;
			$cursor_y_max = 2;
			break;
		case 'choice':
			$cursor_x_max = 1;
			$cursor_y_max = $gameVariables.value(110);
			break
		case '':
			$cursor_x_max = 1;
			$cursor_y_max = 1;
			break;
	}	
	adjust_cursor();
	
	//メニューシーンごとの表示
	if ($menu_scene == 'test') {
		picno = show_test(picno,true);
	}
	if ($menu_scene == 'title') {
		picno = show_titlemenu(picno,true);
	}
	if ($menu_scene == 'mainmenu') {
		picno = show_mainmenu(picno);
	}
	if ($menu_scene == 'save') {
		picno = show_savemenu(picno);
	}
	if ($menu_scene == 'load') {
		picno = show_loadmenu(picno);
	}
	if ($menu_scene == 'titleback') {
		picno = show_titlebackmenu(picno);
	}
	if ($menu_scene == 'interlude') {
		picno = show_interludemenu(picno);
	}
	if ($menu_scene == 'choice') {
		picno = show_choicemenu(picno);
	}
	if ($menu_scene == '') {
		//picno = show_menu_***(picno);
	}
	
	console.log('picno:' + picno.toString());
}

function adjust_cursor() {
	if ($cursor_y_position > $cursor_y_max) {
		if ($cursor_movable_d) {
			$menu_page += 1;
			$cursor_y_position = $cursor_y_max;
		} else {
			if ($cursor_movable_u) {
				$cursor_y_position = $cursor_y_max;
			} else {
				$cursor_y_position = 1;
			}
		}
	} else if ($cursor_y_position == 0) {
		if ($cursor_movable_u) {
			$menu_page -= 1;
			$cursor_y_position = 1;
		} else {
			if ($cursor_movable_d) {
				$cursor_y_position = 1;
			} else {
				$cursor_y_position = $cursor_y_max;
			}
		}
	}
	if ($cursor_x_position > $cursor_x_max) {
		$cursor_x_position = 1;
	} else if ($cursor_x_position == 0) {
		$cursor_x_position = $cursor_x_max;
	}
	
	if ($max_menu_page < $menu_page) {
		$menu_page = $max_menu_page;
	}
	if ($menu_page > 0) {
		$cursor_movable_u = true;
	} else {
		$cursor_movable_u = false;
	}
	if ($menu_page < $max_menu_page) {
		$cursor_movable_d = true;
	} else {
		$cursor_movable_d = false;
	}
}

function erase_menu_picture() {
	for (var i = $MENU_PICNO; i <= $MENU_PICNO_MAX; i = i +1) {
		$gameScreen.erasePicture(i);
	}
}

function set_menu_picture(picno, index_x, index_y, screenx, screeny, width, height) {
	$menu_picture_list[index_x][index_y].enable = true;
	$menu_picture_list[index_x][index_y].picno  = picno;
	$menu_picture_list[index_x][index_y].screenx  = screenx;
	$menu_picture_list[index_x][index_y].screeny  = screeny;
	$menu_picture_list[index_x][index_y].width  = width;
	$menu_picture_list[index_x][index_y].height  = height;
}

function set_button_picture(picno, x, y, width, height, input_key) {
	$button_picture_list.push(function event_picture(picno, x, y, width, height, input_key){});
	
	$button_picture_list[$button_picture_list.length - 1].picno = picno;
	$button_picture_list[$button_picture_list.length - 1].x = x;
	$button_picture_list[$button_picture_list.length - 1].y = y;
	$button_picture_list[$button_picture_list.length - 1].width = width;
	$button_picture_list[$button_picture_list.length - 1].height = height;
	$button_picture_list[$button_picture_list.length - 1].input_key = input_key;
}

function menu_mouse_input() {
	if (TouchInput.isTriggered()) {
		if (touchButtonPicture()) {
			if ($mouse_decide_able || $input_key == 11 || $input_key == 14) {
				return true;
			}
		}
		for (var i = 0; i <= 30; i = i + 1){
			for (var j = 0; j <= 30; j = j + 1){
				if ($menu_picture_list[i][j].enable) {
					if (touchMenuCommand($menu_picture_list[i][j])) {
						//if ($INSTANT_TAP_MODE) {
							//$cursor_x_position = i;    
							//$cursor_y_position = j;
							//$input_key = 5;
							//return true;
						if ($cursor_x_position == i && $cursor_y_position == j) {
							if ($mouse_decide_able) {
								$input_key = 5;
								return true;
							}
						} else {
							$input_key = 100;
							$cursor_x_position = i;    
							$cursor_y_position = j;
							return true;
						}
					}
				}
			}
		}
		if (touchEventPicture()) {
			if ($mouse_decide_able) {
				$input_key = 50;
				return true;
			}
		}
	} else if (TouchInput.isCancelled()) {
		$input_key = 6;
		return true;
	} else	{
		//クリック押しっぱなしの時はカーソル移動しない
		if (!TouchInput.isPressed()) {
			return selectTouchingMenu();
		}
	}
	return false;
}

//カーソルが触れているメニューを選択する
function selectTouchingMenu() {
	if ($INSTANT_TAP_MODE && TouchInput.isHovered()) {
		//メニュー項目
		for (var i = 0; i <= 30; i = i + 1){
			for (var j = 0; j <= 30; j = j + 1){
				if ($menu_picture_list[i][j].enable) {
					if (touchMenuCommand($menu_picture_list[i][j])) {
						if ($cursor_x_position != i || $cursor_y_position != j) {
							$input_key = 100;
							$cursor_x_position = i;
							$cursor_y_position = j;
							return true;
						}
					}
				}
			}
		}
	}
	return false;
}

//メニュー項目にカーソルが触れているかどうかの判定
function touchMenuCommand(menu_picture) {
	if (menu_picture.screenx <= TouchInput.x && TouchInput.x <= (menu_picture.screenx + menu_picture.width) &&
	 menu_picture.screeny <= TouchInput.y && TouchInput.y <= (menu_picture.screeny + menu_picture.height)) {
		return true;
	} else {
		return false;
	}
}

//ボタンピクチャーに触れているかどうかの判定（触れているボタンに設定したinput_keyの値を格納する）
function touchButtonPicture() {
	for (var i = 0; i < $button_picture_list.length; i = i + 1) {
		button_picture = $button_picture_list[i];
		if ((button_picture.x <= TouchInput.x) && (TouchInput.x <= (button_picture.x + button_picture.width)) &&
		 (button_picture.y <= TouchInput.y) && (TouchInput.y <= (button_picture.y + button_picture.height))) {
		 	$input_key = button_picture.input_key;
		 	return true;
		} else {
		}
	}
	return false;
}

function format_button_picture_list() {
	$button_picture_list = [];
}

//以下にメニューシーンごとの表示を記述
function show_title(picno,commandVisible) {
	var value, y;
	$gameScreen.showPicture(picno, 'title', 0, 0, 0, 100, 100, 255, 0);
	picno += 1;
	$gameScreen.showPicture(picno, 'title_screen', 0, 0, 0, 100, 100, 255, 2);
	picno += 1;
	
	if (commandVisible) {
		$gameScreen.showPicture(picno, 'title_cursor1', 0, 0, 98 + (($cursor_y_position - 1) * 120), 100, 100, 255, 3);
		picno += 1;
		for (var i = 1; i <= 2; i = i + 1) {
			value = 120;
			if (i == $cursor_y_position) value = 255;		
			y = 140 + ((i - 1) * 120);
			$gameScreen.showPicture(picno, 'title_command' + i.toString(), 0, 232, y, 100, 100, value, 0);
			set_menu_picture(picno, 1, i, 0, y, 816, 80);
			picno += 1;
		}
		$gameScreen.showPicture(picno, 'title_command_caption' + $cursor_y_position.toString(), 0, 18, 165 + (($cursor_y_position - 1) * 120), 100, 100, 255, 0);
		picno += 1;
	}
	
	picno = show_savedataOnTitle(picno);
	
	return picno;
}

function show_test(picno,commandVisible) {
	var value, y;
	$gameScreen.showPicture(picno, 'menu_back', 0, 0, 0, 100, 100, 255, 0);
	picno += 1;
	
	if (commandVisible) {
		$gameScreen.showPicture(picno, 'menu_cursor', 0, 65, 125 + (($cursor_y_position - 1) * 64), 100, 100, 255, 0);
		picno += 1;
		$gameScreen.showPicture(picno, 'menu_select1', 0, 178, 127, 100, 100, 255, 0);
		set_menu_picture(picno, 1, 1, 178, 127, 143, 43);
		picno += 1;
		$gameScreen.showPicture(picno, 'menu_select2', 0, 178, 192, 100, 100, 255, 0);
		set_menu_picture(picno, 1, 2, 178, 192, 143, 43);
	}
	
	return picno;
}


//□□□□□□□□□
//タイトルメニュー表示
//□□□□□□□□□

function show_titlemenu(picno) {
	var value;
	
	$gameScreen.showPicture(picno, 'TitleMenu' + $gameVariables.value(100).toString() , 0, 0, 0, 100, 100, 255, 0);
	picno += 1;
	
	for (var i = 1; i <= 2; i = i + 1) {		
		if ($cursor_y_position == i) {
			value = 255;
			$gameScreen.showPicture(picno, 'TitleMenu_cursor', 1, 240, 570 + ((i - 1) * 50), 100, 100, 255, 0);
			picno += 1;
		} else 	{
			value = 133;
		}		
		$gameScreen.showPicture(picno, 'TitleMenu_' + i.toString(), 1, 240, 569 + ((i - 1) * 50), 100, 100, value, 0);		
		//$gameScreen.tintPicture(picno, [ value, value, value, 0 ], 1)		
		set_menu_picture(picno, 1, i, 0, 552 + ((i - 1) * 50), 480, 36);
		picno += 1;
	}
	
	return picno; 
}



//□□□□□□□□□
//メインメニュー表示
//□□□□□□□□□
function show_mainmenu(picno) {
	var value, y;
	$gameScreen.showPicture(picno, 'BlackScreen', 0, 0, 0, 100, 100, 128, 0);
	picno += 1;
	
	if ($cursor_y_position != 4) {
		$gameScreen.showPicture(picno, 'MainMenu_cursor', 1, 240, 373 + (($cursor_y_position - 1) * 63), 100, 100, 255, 0);
		picno += 1;
	}
	
	for (var i = 1; i <= 3; i = i + 1) {		
		if ($cursor_y_position == i) {
			value = 255;
		} else 	{
			value = 128;
		}		
		$gameScreen.showPicture(picno, 'MainMenu_' + i.toString(), 1, 240, 373 + ((i - 1) * 63), 100, 100, value, 0);
		set_menu_picture(picno, 1, i, 0, 357 + ((i - 1) * 63), 480, 34);
		picno += 1;
	}
	
	picno = show_backbutton(picno, 4);
		
	return picno;
}

//□□□□□□□□□
//戻るボタン表示
//□□□□□□□□□
function show_backbutton(picno, cursor_y) {
	var value;
	$gameScreen.showPicture(picno, 'BackButton_screen', 1, 240, 759, 100, 100, 255, 0);
	picno += 1;
	if ($cursor_y_position == cursor_y) {	
		value = 255;
	} else 	{
		value = 128;
	}
	$gameScreen.showPicture(picno, 'BackButton_line', 1, 240, 759, 100, 100, value, 0);
	picno += 1;
	$gameScreen.showPicture(picno, 'BackButton_text', 1, 240, 759, 100, 100, value, 0);
	set_menu_picture(picno, 1, cursor_y, 0, 739, 480, 38);
	picno += 1;
	
	return picno;
}

//□□□□□□□□□
//セーブメニュー表示
//□□□□□□□□□
function show_savemenu(picno) {
	$gameScreen.showPicture(picno, 'BlackScreen', 0, 0, 0, 100, 100, 128, 0);
	picno += 1;
	$gameScreen.showPicture(picno, 'SaveMenu', 0, 0, 0, 100, 100, 255, 0);
	picno += 1;
	
	picno = show_savedata(picno);
	
	picno = show_backbutton(picno, 4);
	
	return picno;
}

//□□□□□□□□□
//ロードメニュー表示
//□□□□□□□□□
function show_loadmenu(picno) {
	$gameScreen.showPicture(picno, 'BlackScreen', 0, 0, 0, 100, 100, 128, 0);
	picno += 1;
	$gameScreen.showPicture(picno, 'LoadMenu', 0, 0, 0, 100, 100, 255, 0);
	picno += 1;
	
	picno = show_savedata(picno);
	
	picno = show_backbutton(picno, 4);
	
	return picno;
}

//□□□□□□□□□
//セーブデータ表示
//□□□□□□□□□
function show_savedata(picno) {
	var x, value;
	
	for (var i = 1; i <= 3; i = i + 1) {
		if ($cursor_y_position == i) {	
			value = 255;
		} else 	{
			value = 128;
		}
		$gameScreen.showPicture(picno, 'DataWindow_screen', 1, 240, 238 + ((i - 1) * 190), 100, 100, 255, 2);
		picno += 1;
		$gameScreen.showPicture(picno, 'DataWindow_line', 1, 240, 238 + ((i - 1) * 190), 100, 100, value, 0);
		set_menu_picture(picno, 1, i, 37, 161 + ((i - 1) * 190), 406, 154);
		picno += 1;
		$gameScreen.showPicture(picno, 'num_' + i.toString(), 01, 58, 183 + ((i - 1) * 190), 100, 100, value, 0);
		picno += 1;
		
		if (DataManager.savefileExists(i)) {
			//const date = new Date(DataManager.savefileInfo(i).year, DataManager.savefileInfo(i).month, DataManager.savefileInfo(i).day); 
			const date = new Date(DataManager.savefileInfo(i).timestamp); 
			
			$gameScreen.showPicture(picno, 'DataWindow_template', 0, 136, 183 + ((i - 1) * 190), 100, 100, value, 0);
			picno += 1;
			$gameScreen.showPicture(picno, 'num_' + DataManager.savefileInfo(i).chapter.toString(), 0, 309, 179 + ((i - 1) * 190), 100, 100, value, 0);
			picno += 1;
			
			//$gameScreen.showPicture(picno, 'num_' + DataManager.savefileInfo(i).scene.toString(), 0, 260, 225 + ((i - 1) * 190), 100, 100, value, 0);
			//picno += 1;
			
			x = 260
			var scene = DataManager.savefileInfo(i).scene.toString();
			for (var j = 1; j <= scene.length; j = j + 1) {
				$gameScreen.showPicture(picno, 'num_' + scene.charAt(j-1), 0, x, 225 + ((i - 1) * 190), 100, 100, value, 0);
				picno += 1;
				x += 19;
			}			
			
			picno = show_date(picno, date, 130, 271 + ((i - 1) * 190), value);
		}
	}	
	return picno;
}


//□□□□□□□□□
//日付時間表示
//□□□□□□□□□
function show_date(picno,date,x,y,untrans) {
	var year = date.getFullYear().toString();
	for (var i = 1; i <= year.length; i = i + 1) {
		$gameScreen.showPicture(picno, 'num_' + year.charAt(i-1), 0, x, y, 100, 100, untrans, 0);
		picno += 1;
		x += 19;
	}
	
	$gameScreen.showPicture(picno, 'num_slash', 0, x, y, 100, 100, untrans, 0);
	picno += 1;
	x += 19;
	var month = (date.getMonth() + 1).toString();
	for (var i = 1; i <= month.length; i = i + 1) {
		$gameScreen.showPicture(picno, 'num_' + month.charAt(i-1), 0, x, y, 100, 100, untrans, 0);
		picno += 1;
		x += 19;
	}
	$gameScreen.showPicture(picno, 'num_slash', 0, x, y, 100, 100, untrans, 0);
	picno += 1;
	x += 19;
	var day = date.getDate().toString();
	for (var i = 1; i <= day.length; i = i + 1) {
		$gameScreen.showPicture(picno, 'num_' + day.charAt(i-1), 0, x, y, 100, 100, untrans, 0);
		picno += 1;
		x += 19;
	}
	x += 15;
	var hour = date.getHours().toString();
	for (var i = 1; i <= hour.length; i = i + 1) {
		$gameScreen.showPicture(picno, 'num_' + hour.charAt(i-1), 0, x, y, 100, 100, untrans, 0);
		picno += 1;
		x += 19;
	}
	$gameScreen.showPicture(picno, 'num_colon', 0, x, y, 100, 100, untrans, 0);
	picno += 1;
	x += 10;
	var min = date.getMinutes().toString();
	min = ('0' + min).slice(-2);
	for (var i = 1; i <= min.length; i = i + 1) {
		$gameScreen.showPicture(picno, 'num_' + min.charAt(i-1), 0, x, y, 100, 100, untrans, 0);
		picno += 1;
		x += 19;
	}
	//$gameScreen.showPicture(picno, 'num_colon', 0, x, y, 100, 100, untrans, 0);
	//picno += 1;
	//x += 10;
	//var sec = date.getSeconds().toString();
	//sec = ('0' + sec).slice(-2);
	//for (var i = 1; i <= sec.length; i = i + 1) {
	//	$gameScreen.showPicture(picno, 'num_' + sec.charAt(i-1), 0, x, y, 100, 100, untrans, 0);
	//	picno += 1;
	//	x += 19;
	//}
	
	return picno;
}


//□□□□□□□□□
//タイトルバックメニュー表示
//□□□□□□□□□
function show_titlebackmenu(picno) {
	var value, frame, y;
	$gameScreen.showPicture(picno, 'BlackScreen', 0, 0, 0, 100, 100, 128, 0);
	picno += 1;
	$gameScreen.showPicture(picno, 'TitleBackMenu_base', 0, 0, 0, 100, 100, 255, 0);
	picno += 1;
	
	for (var i = 1; i <= 2; i = i + 1) {		
		if ($cursor_y_position == i) {
			frame = 'TitleBackMenu_frame_selected';
			value = 255;
		} else 	{
			frame = 'TitleBackMenu_frame';
			value = 128;
		}		
		$gameScreen.showPicture(picno, frame, 1, 240, 410 + ((i - 1) * 86), 100, 100, 255, 0);
		set_menu_picture(picno, 1, i, 146, 386 + ((i - 1) * 86), 188, 48);
		picno += 1;
		
		$gameScreen.showPicture(picno, 'TitleBackMenu_' + i.toString(), 1, 240, 409 + ((i - 1) * 86), 100, 100, value, 0);
		picno += 1;
	}
		
	return picno;
}


//□□□□□□□□□
//中間メニュー表示
//□□□□□□□□□

function show_interludemenu(picno) {
	var value;
	
	$gameScreen.showPicture(picno, 'BlackScreen', 0, 0, 0, 100, 100, 255, 0);
	picno += 1;	
	
	if ($gameSwitches.value(115)) {
		$gameScreen.showPicture(picno, 'InterludeCaptionEnd', 0, 0, 0, 100, 100, 255, 0);
	} else {
		$gameScreen.showPicture(picno, 'InterludeCaption', 0, 0, 0, 100, 100, 255, 0);
	}
	picno += 1;
	
	$gameScreen.showPicture(picno, 'num_' + $gameVariables.value(101).toString(), 0, 194, 17, 100, 100, 133, 0);
	picno += 1;	
	
	for (var i = 1; i <= 2; i = i + 1) {		
		if ($cursor_y_position == i) {
			value = 255;
			$gameScreen.showPicture(picno, 'TitleMenu_cursor', 1, 240, 394 + ((i - 1) * 50), 100, 100, 255, 0);
			picno += 1;
		} else 	{
			value = 133;
		}		
		$gameScreen.showPicture(picno, 'InterludeMenu_' + i.toString(), 1, 240, 393 + ((i - 1) * 50), 100, 100, value, 0);
		set_menu_picture(picno, 1, i, 0, 377 + ((i - 1) * 50), 480, 34);
		picno += 1;
	}
	
	return picno; 
}


//□□□□□□□□□
//選択肢表示
//□□□□□□□□□
function show_choicemenu(picno) {
	var x, y, value;

	//$gameScreen.showPicture(picno, 'BlackScreen', 0, 0, 0, 100, 100, 128, 0);
	//picno += 1;
	
	for (var i = 1; i <= $cursor_y_max; i = i + 1) {
		//歩く選択肢かどうか
		if ($gameSwitches.value(121)) {
			x = $choicebutton_x[i];
			y = Math.floor(Math.random() * (480 - 120) + 200);
		} else {
			x = 240;
			y = 408 - ((($cursor_y_max - 1) * 110) / 2) + ((i - 1) * 110);
		}
		
		if ($cursor_y_position == i) {
			value = 255;
			$gameScreen.showPicture(picno, 'ChoiceButton_screen_s', 1, x, y, 100, 100, 255, 2);
			set_menu_picture(picno, 1, i, x - 134, y - 34, 268, 68);
			picno += 1;
			$gameScreen.showPicture(picno, 'ChoiceButton_cursor', 1, x, y, 100, 100, 100, 3);
			picno += 1;
		} else {
			value = 128;
			$gameScreen.showPicture(picno, 'ChoiceButton_screen', 1, x, y, 100, 100, 255, 2);
			set_menu_picture(picno, 1, i, x - 134, y - 34, 268, 68);
			picno += 1;
		}
		
		$gameScreen.showPicture(picno, 'ChoiceButton_line', 1, x, y, 100, 100, value, 0);
		picno += 1;
		
		$gameScreen.showPicture(picno, 'ChoiceCommand_' + $gameVariables.value(110 + i).toString(), 1, x, y - 5, 100, 100, value, 0);
		picno += 1;
	}
	
	$gameScreen.showPicture(picno, 'MenuButton', 0, 0, 0, 100, 100, 255, 0);
	set_button_picture(picno, 330, 38, 150, 36, 6);
	
	return picno;
}


function show_savedataOnTitle(picno) {
	if (DataManager.isAnySavefileExists() && $gameSwitches.value(21)) {
		$gameScreen.showPicture(picno, "latestdata", 0, 130, 562, 100, 100, 200, 0);
		picno += 1;
		globalInfo = DataManager.loadGlobalInfo();		
		date = new Date(globalInfo[1].year,globalInfo[1].month,globalInfo[1].day,globalInfo[1].hour,globalInfo[1].min,globalInfo[1].sec);
		picno = show_date(picno,date,98,578,255);
	}
	return picno;
}

function show_menu_standby(picno) {
	$gameScreen.showPicture(picno, 'menu_toggle', 0, 663, 0, 100, 100, 255, 0);
	set_button_picture(picno, 650, 0, 165, 90, 6);
	picno += 1;
	return picno;
}

function show_basic_menu(picno) {
	var x,y,filename;
	
	$gameScreen.showPicture(picno, 'menuback_basic', 0, 0, 0, 100, 100, 255, 0);
	picno += 1;
	
	$gameScreen.showPicture(picno, 'menu_close', 0, 737, 21, 100, 100, 255, 0);
	set_button_picture(picno, 717, 0, 99, 99, 6);
	picno += 1;
	
	set_button_picture(picno, 0, 0, 400, 624, 6);
	picno += 1;
	
	for (var i = 1; i <= 4; i = i + 1) {
		//物語メニューが解放されていないとき
		if (i == 4 && !$gameSwitches.value(61)) {
			break;
		}
		
		if ($cursor_y_position == i) {
			x = 434;
			filename = 'menu_command_base_selected';
		} else {
			x = 501;
			filename = 'menu_command_base';
		}
		y = 130 + ((i - 1) * 80);
		$gameScreen.showPicture(picno, filename, 0, x, y, 100, 100, 255, 0);		
		if ($cursor_y_position != i) {
			$gameScreen.tintPicture(picno, [-255,-255,-255,0], 0);
		} else if (!$gameSwitches.value(103)) {
			$gameScreen.tintPicture(picno, [0,0,0,255], 0);
		}
		set_menu_picture(picno, 1, i, 434, y - 5, 382, 68);
		picno += 1;
		
		if (i >= 2 && !$gameSwitches.value(61)) {
			filename = 'basic_menu_command' + (i+1).toString();
		} else {
			filename = 'basic_menu_command' + i.toString();
		}
		$gameScreen.showPicture(picno, filename, 0, x, y, 100, 100, 255, 0);
		//if ($cursor_y_position == i) {
		$gameScreen.tintPicture(picno, [255,255,255,255], 0);
		//}
		picno += 1;
	}
	
	picno = show_memorystatus(picno);
	
	return picno;
}

function show_memorystatus(picno) {
	if ($gameSwitches.value(61)) {
		picno = show_memorystatus1(picno, 484);
		picno = show_memorystatus2(picno, 537);
	} else {
		picno = show_memorystatus1(picno, 537);
	}
	return picno;
}

function show_memorystatus1(picno, y) {
	$gameScreen.showPicture(picno, "memorystatus1", 0, 501, y, 100, 100, 255, 0);
	picno += 1;
	
	x = 669;
	str = $gameParty.gold().toString();
	for (var i = 1; i <= str.length; i = i + 1) {
		$gameScreen.showPicture(picno, "memorynum_" + str.charAt(i-1), 0, x, y, 100, 100, 255, 0);
		picno += 1;
		x += 9;
	}
	
	return picno;
}
function show_memorystatus2(picno, y) {
	$gameScreen.showPicture(picno, "memorystatus2", 0, 501, y, 100, 100, 255, 0);
	picno += 1;
	
	$gameScreen.showPicture(picno, "memorynum_" + $gameVariables.value(71).toString(), 0, 669, y, 100, 100, 255, 0);
	picno += 1;
	
	return picno;
}

function show_restore_menu(picno) {	
	var x;
	
	$gameScreen.showPicture(picno, 'menuback_restore', 0, 0, 0, 100, 100, 130, 0);
	picno += 1;
	$gameScreen.showPicture(picno, 'restore_caption', 0, 96, 111, 100, 100, 255, 0);
	picno += 1;
	
	$gameScreen.showPicture(picno, 'menu_back_w', 0, 737, 21, 100, 100, 255, 0);
	set_button_picture(picno, 717, 0, 99, 99, 6);
	picno += 1;
	
	$gameScreen.showPicture(picno, 'restore_command', 0, 235, 298, 100, 100, 255, 0);
	set_button_picture(picno, 235, 298, 310, 58, 5);
	picno += 1;
	
	picno = show_next_restoretime(picno);
	
	picno = show_memorystatus(picno);
	
	return picno;
}
function show_next_restoretime(picno) {
	if ($gameSwitches.value(91)) {
		var AMPM;
		var date = new Date();
		if (AMorPM(date.getHours()) == "AM") {
			AMPM = "pm";
		} else {
			date.setDate(date.getDate() + 1);
			AMPM = "am";
		}
		var year = (date.getYear() + 1900).toString();
		var month = (date.getMonth() + 1).toString();
		var day = date.getDate().toString();
		
		$gameScreen.showPicture(picno, "nexttime", 0, 388, 425, 100, 100, 255, 0);
		picno += 1;
		
		x = 624;
		for (var i = 1; i <= year.length; i = i + 1) {
			$gameScreen.showPicture(picno, "memorynum_" + year.charAt(i-1), 0, x, 425, 100, 100, 255, 0);
			$gameScreen.tintPicture(picno, [255,255,255,255], 0);
			picno += 1;
			x += 9;
		}
		$gameScreen.showPicture(picno, "memorynum_slash", 0, x, 425, 100, 100, 255, 0);
		$gameScreen.tintPicture(picno, [255,255,255,255], 0);
		picno += 1;
		x += 9;
		for (var i = 1; i <= month.length; i = i + 1) {
			$gameScreen.showPicture(picno, "memorynum_" + month.charAt(i-1), 0, x, 425, 100, 100, 255, 0);
			$gameScreen.tintPicture(picno, [255,255,255,255], 0);
			picno += 1;
			x += 9;
		}
		$gameScreen.showPicture(picno, "memorynum_slash", 0, x, 425, 100, 100, 255, 0);
		$gameScreen.tintPicture(picno, [255,255,255,255], 0);
		picno += 1;
		x += 9;
		for (var i = 1; i <= day.length; i = i + 1) {
			$gameScreen.showPicture(picno, "memorynum_" + day.charAt(i-1), 0, x, 425, 100, 100, 255, 0);
			$gameScreen.tintPicture(picno, [255,255,255,255], 0);
			picno += 1;
			x += 9;
		}
		x += 3;
		$gameScreen.showPicture(picno, "memorynum_" + AMPM, 0, x, 425, 100, 100, 255, 0);
		picno += 1;
	}
	return picno;
}

function show_story_menu(picno) {
	var x,y,no,filename;
	
	$gameScreen.showPicture(picno, 'menuback_stories', 0, 0, 0, 100, 100, 255, 0);
	picno += 1;
	
	$gameScreen.showPicture(picno, 'menu_back_b', 0, 737, 21, 100, 100, 255, 0);
	set_button_picture(picno, 717, 0, 99, 99, 6);
	picno += 1;
	
	no = 1;
	for (var i = 1; i <= 7; i = i + 1) {
		for (var j = 1; j <= 3; j = j + 1) {
			x = 30 + (256 * (j - 1));
			y = 125 + (68 * (i - 1));
			$gameScreen.showPicture(picno, 'item_base', 0, x, y, 100, 100, 255, 0);
			set_menu_picture(picno, j, i, x, y, 240, 52);
			picno += 1;
			if ($cursor_x_position == j && $cursor_y_position == i) {
				$gameScreen.showPicture(picno, 'item_cursor', 0, x, y, 100, 100, 255, 0);
				picno += 1;
			}
			if ($gameParty.hasItem($dataWeapons[no], false)) {
				$gameScreen.showPicture(picno, 'story' + no.toString(), 0, x, y, 100, 100, 255, 0);
				picno += 1;
			}
			no += 1;
		}
	}
	
	return picno;
}

function show_collection_menu(picno) {
	var x,y,no,filename;
	
	$gameScreen.showPicture(picno, 'menuback_collections', 0, 0, 0, 100, 100, 255, 0);
	picno += 1;
	
	$gameScreen.showPicture(picno, 'menu_back_b', 0, 737, 21, 100, 100, 255, 0);
	set_button_picture(picno, 717, 0, 99, 99, 6);
	picno += 1;
	
	for (var i = 1; i <= 6; i = i + 1) {
		no = $menu_page + i;
		
		x = 34;
		y = 128 + (72 * (i - 1));
		$gameScreen.showPicture(picno, 'item_base', 0, x, y, 100, 100, 255, 0);
		set_menu_picture(picno, 1, i, x, y, 240, 52);
		picno += 1;
		if ($cursor_y_position == i) {
			$gameScreen.showPicture(picno, 'item_cursor', 0, x, y, 100, 100, 255, 0);
			picno += 1;
		}
		if ($gameParty.hasItem($dataItems[no])) {
			$gameScreen.showPicture(picno, 'collection' + no.toString(), 0, x, y, 100, 100, 255, 0);
			picno += 1;
		}
	}
	
	if ($cursor_movable_u) {
		$gameScreen.showPicture(picno, 'arrow_u', 0, 98, 82, 100, 100, 255, 0);
		set_button_picture(picno, 34, 16, 240, 96, 14);
		picno += 1;
	}
	if ($cursor_movable_d) {
		$gameScreen.showPicture(picno, 'arrow_d', 0, 98, 560, 100, 100, 255, 0);
		set_button_picture(picno, 34, 550, 240, 72, 11);
		picno += 1;
	}
	
	$gameScreen.showPicture(picno, 'collection_note_base', 0, 300, 128, 100, 100, 255, 0);
	picno += 1;
	
	var itemno = $cursor_y_position + $menu_page
	if ($gameParty.hasItem($dataItems[itemno])) {
		$collectionWindow.refresh(itemno);
	} else {
		$collectionWindow.refresh(0);
	}	
	
	x = 705;
	var str = itemno.toString();
	for (var i = 1; i <= str.length; i = i + 1) {
		$gameScreen.showPicture(picno, "memorynum_" + str.charAt(str.length-i), 0, x, 492, 100, 100, 255, 0);
		$gameScreen.tintPicture(picno, [255,255,255,255], 0);
		picno += 1;
		x -= 9;
	}
	
	return picno;
}

function show_system_menu(picno) {
	var x,y,filename;
	
	$gameScreen.showPicture(picno, 'menuback_system', 0, 0, 0, 100, 100, 168, 2);
	picno += 1;
	
	$gameScreen.showPicture(picno, 'menu_back_b', 0, 737, 21, 100, 100, 255, 0);
	set_button_picture(picno, 717, 0, 99, 99, 6);
	picno += 1;
	
	for (var i = 1; i <= 4; i = i + 1) {
		x = 254;
		y = 148 + (80 * (i - 1));
		$gameScreen.showPicture(picno, 'system_command_base', 0, x, y, 100, 100, 255, 0);
		picno += 1;
		set_menu_picture(picno, 1, i, x, y, 310, 58);
		
		if ($cursor_y_position == i) {
			$gameScreen.showPicture(picno, 'system_command_cursor', 0, x, y, 100, 100, 255, 0);
			picno += 1;
		}
		
		filename = 'system_command' + i.toString();
		$gameScreen.showPicture(picno, filename, 0, x, y, 100, 100, 255, 0);
		$gameScreen.tintPicture(picno, [255,255,255,255], 0);
		picno += 1;
	}
	
	if ($gameSwitches.value(55)) {
		filename = "autosave_on";
	} else {
		filename = "autosave_off";
	}
	$gameScreen.showPicture(picno, filename, 1, 408, 576, 100, 100, 255, 0);
	picno += 1;
	
	return picno;
}

function show_save_menu(picno) {
	var x,y,filename;
	
	$gameScreen.showPicture(picno, 'menuback_save', 0, 0, 0, 100, 100, 255, 0);
	picno += 1;
	
	$gameScreen.showPicture(picno, 'menu_back_b2', 0, 737, 21, 100, 100, 255, 0);
	set_button_picture(picno, 717, 0, 99, 99, 6);
	picno += 1;
	
	$gameScreen.showPicture(picno, 'save_command', 0, 421, 516, 100, 100, 255, 0);
	set_button_picture(picno, 421, 516, 304, 45, 5);
	picno += 1;	
	
	var date = new Date();
	picno = show_date(picno,date,267,224,255);
	
	y = 330;
	if (DataManager.isAnySavefileExists() && $gameSwitches.value(21)) {
		$gameScreen.showPicture(picno, "latestdata", 0, 182, 318, 100, 100, 200, 0);
		$gameScreen.tintPicture(picno, [0,0,0,255], 0);
		picno += 1;
		globalInfo = DataManager.loadGlobalInfo();		
		date = new Date(globalInfo[1].year,globalInfo[1].month,globalInfo[1].day,globalInfo[1].hour,globalInfo[1].min,globalInfo[1].sec);
		picno = show_date(picno,date,150,y,178);
	} else {
		$gameScreen.showPicture(picno, "nodata", 0, 226, y, 100, 100, 178, 0);
		picno += 1;
	}	
}

function show_load_menu(picno) {
	var x,y,filename;
	
	$gameScreen.showPicture(picno, 'menuback_load', 0, 0, 0, 100, 100, 255, 0);
	picno += 1;
	
	$gameScreen.showPicture(picno, 'menu_back_b2', 0, 737, 21, 100, 100, 255, 0);
	set_button_picture(picno, 717, 0, 99, 99, 6);
	picno += 1;
	
	$gameScreen.showPicture(picno, 'load_command', 0, 421, 516, 100, 100, 255, 0);
	set_button_picture(picno, 421, 516, 304, 45, 5);
	picno += 1;		
	
	var date = new Date();
	picno = show_date(picno,date,267,224,178);
	
	y = 330;
	if (DataManager.isAnySavefileExists() && $gameSwitches.value(21)) {
		$gameScreen.showPicture(picno, "latestdata", 0, 182, 318, 100, 100, 200, 0);
		$gameScreen.tintPicture(picno, [0,0,0,255], 0);
		picno += 1;
		globalInfo = DataManager.loadGlobalInfo();		
		date = new Date(globalInfo[1].year,globalInfo[1].month,globalInfo[1].day,globalInfo[1].hour,globalInfo[1].min,globalInfo[1].sec);
		picno = show_date(picno,date,150,y,255);
	} else {
		$gameScreen.showPicture(picno, "nodata", 0, 226, y, 100, 100, 255, 0);
		picno += 1;
	}	
}


//メニューエフェクト
//メニューエフェクト画像表示
function display_menueffect() {
	var picno;
	
	for (var i = 0; i <= ($MENUEFFECT_PICNO_MAX - $MENUEFFECT_PICNO); i = i + 1) {
		if ($menueffect_list[i].exist) {
			mode = 0;
			switch ($menueffect_list[i].type) {
				case '':
					break;
				case '':
					break;
			}
			
			picno = i + $MENUEFFECT_PICNO;
			
			graphic = $menueffect_list[i].graphic;
			x = $menueffect_list[i].x;
			y = $menueffect_list[i].y;
			untrans = $menueffect_list[i].trans;
			exp = $menueffect_list[i].exp;
			
			$gameScreen.showPicture(picno, 'effect/' + graphic, 1, x, y, exp, exp, untrans, mode);
		}
	}
}

//メニューエフェクト表示メソッド
function show_menueffect(i, type, graphic, x, y, speedx, speedy, exp, untrans, option = '') {
	$menueffect_list[i].exist = true;
	$menueffect_list[i].type = type;
	$menueffect_list[i].graphic = graphic;
	$menueffect_list[i].x = x;
	$menueffect_list[i].y = y;
	$menueffect_list[i].speedx = speedx;
	$menueffect_list[i].speedy = speedy;
	$menueffect_list[i].exp = exp;
	$menueffect_list[i].untrans = untrans;
	$menueffect_list[i].time = 0;
	$menueffect_list[i].option = option;
}

//メニューエフェクト消去
function remove_menueffect(i) {
	$menueffect_list[i].exist = false;
	$gameScreen.erasePicture(i + $MENUEFFECT_PICNO);
}